#
# XML:Compile - SOAP1.2 - test
#
use strict;
use XML::Compile::SOAP12;
use XML::Compile::WSDL11;
use XML::Compile::Transport::SOAPHTTP;
use URI;
use Data::Dumper;

my $wsdl = XML::Compile::WSDL11->new('soap12.wsdl');

my @defs = qw/01596e3e437a4f87527c0778fd9f49e7.xml 056658c91aade7611e6d20968f13c139.xml 0995ae7ed904ad2fb4b8a7d8f28144fa.xml 1ded196b304fce690aacc09104666da4.xml 2360ec9a8765f47ca47accd6dbb863e3.xml 3549114751d6e338e3d511fbcfeb9c3c.xml 4cad968f3126a38859c9ca0ec6cfe4a8.xml 50b034117d3d8c5bf8526b083051b372.xml 5b405bb541bcdbc37409714fb42242e2.xml 5fdf7ca3b11569c20ee4df91ee4e2eef.xml c7631f0b928a98a314a40ea3155a650c.xml ef72890673560e739b76d413e78a229e.xml/;
foreach my $file ( @defs ) { $wsdl->importDefinitions($file) }

my $uri  = URI->new($wsdl->endPoint);
my $http = XML::Compile::Transport::SOAPHTTP->new(address => $uri->as_string, timeout => 4);
my $transport = $http->compileClient(action => 'getTigoExchangeSubscriptionsInfo');          
my $call = $wsdl->compileClient( operation => 'getTigoExchangeSubscriptionsInfo', transport => $transport);

my $client = { 
			    id => '1234567890',
			    idType => 'MSISDN'
	         };

my $request = { client  => $client };
my ($response, $trace) = $call->($request);

print "---\n";
$trace->printRequest;
print Dumper({Data => $request}), "\n";

print "---\n";
$trace->printResponse;
print Dumper({Data => $response}), "\n";
