#!/usr/bin/python

from essax import EssaxParser, RuntimeParseError, InvalidTagFormat
from essax import ValidationError


class TestParser (EssaxParser):
    
    def __init__(self, file_name):
        EssaxParser.__init__(self, file_name)
        
        rtf = self.register_tag_format
        rta = self.register_tag_attributes
        
        rtf('xml', 'module_descrip import* (structure* union*) order? next')

        rtf('structure', '(byte* int8* cstring* array* structure*)')
        rtf('array',     '(byte* int8* cstring*        structure*)')
        
        rta('import', 'module', 'as')
        
        rta('structure', 'name=string')
        
        rta('byte', 'name')
        rta('int8', 'name')
        
        rta('cstring', 'name, length=integer')
        
        rta('array', 'name, length=integer')
        
        rta('union', 'name', 'use_header=boolean')
        
        self.keep_subtags_for( 'array structure' )
        
        
    #--------------------------------------------------------------------------
    # <xml>
    #
    def tag_begin_xml(self):
        print 'Beginning <xml>'
        
    def tag_end_xml(self):
        print 'Ending <xml>'
        
        
    #--------------------------------------------------------------------------
    # <module>
    #
    def tag_module_descrip(self):
        print '    Module Descrip Contents: "%s"' % self.this_tag.text
        
        
    #--------------------------------------------------------------------------
    # <import>
    #
    def tag_import(self):
        mod = self.this_tag.attrs['module']
        tas = self.this_tag.attrs.get('as', 'DefaultValue')
        print '    import. module = %s, as = %s' % (mod, tas)
        

    #--------------------------------------------------------------------------
    # <structure>
    #
    def tag_begin_structure(self):
        print '    Begin structure: ', self.this_tag.attrs['name']
        
        
    def tag_end_structure(self):
        print '    End structure: ', self.this_tag.attrs['name']
        
        
    #--------------------------------------------------------------------------
    # <union>
    #
    def tag_begin_union(self):
        name   = self.this_tag.attrs['name']
        header = self.this_tag.attrs.get('use_header', False)
        print '    Begin union: %s, use_header = %s' % (name, header)
        
    def tag_end_union(self):
        print '    End union: ', self.this_tag.attrs['name']
        
        
    #--------------------------------------------------------------------------
    # <byte>
    #
    def tag_byte(self):
        print '        Byte: ', self.this_tag.attrs['name']
        
    #--------------------------------------------------------------------------
    # <int8>
    #
    def tag_int8(self):
        print '        Int8: ', self.this_tag.attrs['name']
        
    
    #--------------------------------------------------------------------------
    # <cstring>
    #
    def tag_cstring(self):
        name   = self.this_tag.attrs['name']
        length = self.this_tag.attrs['length']
        print '        CString: %s length = %d' % (name, length)
        
        
    #--------------------------------------------------------------------------
    # <array>
    #
    def tag_array(self):
        name   = self.this_tag.attrs['name']
        length = self.this_tag.attrs['length']
        print '        Array: %s length = %d' % (name, length)
        
        if len(self.this_tag.sub_tags) > 0:
            print '        **** HAS SUBTAG ****'
        
        
    #--------------------------------------------------------------------------
    # <order>
    #
    def tag_order(self):
        print '        Order: ', self.this_tag.attrs['name']
        
    
    #--------------------------------------------------------------------------
    # <next>
    #
    def tag_next(self):
        print '        Next: ', self.this_tag.attrs['name']
    
        
        
        
if __name__ == '__main__':
    
    tp = TestParser('format_test.xml')
    
    tp.parse()
        
    
        
    
