<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version = '1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<xsl:output method="xml" version="1.0" encoding="UTF-8" omit-xml-declaration="no" indent="yes"/>

<xsl:template match="root">
<chapter id="testresults">
<title>Test Results</title>

<para>This chapter gives an overview of the results of the executed tests.</para>


<section>
<title>Test Results Summary</title>
<para>This section summarizes the test run.</para>
<table>
	<title>Test Results Summary</title>
	<tgroup cols="2">
		<colspec colname="col1" colwidth="150.0pt" colnum="1"/>
		<tbody>
			<row>
				<entry>Total tests:</entry>
				<entry><xsl:value-of select="total_tests"/></entry>
			</row>
			<row>
				<entry>Passed tests:</entry>
				<entry><xsl:value-of select="passed_tests"/></entry>
			</row>
			<row>
				<entry>Failed tests:</entry>
				<entry><xsl:value-of select="failed_tests"/></entry>
			</row>
			<row>
				<entry>Failed due to known bugs:</entry>
				<entry><xsl:value-of select="failed_known_tests/count"/></entry>
			</row>
			<row>
				<entry>Skipped tests:</entry>
				<entry><xsl:value-of select="skipped_tests"/></entry>
			</row>
			<row>
				<entry>Total Elapsed Time:</entry>
				<entry><xsl:value-of select="elapsed_time"/></entry>
			</row>
		</tbody>
	</tgroup>
</table>
</section>


<section>
<title>Test Results Overview</title>
<para>This section gives an overview of the test results for regression tests, including incidents found during test execution.</para>

<table >
	<title>Test Results</title>
	<tgroup cols="5">
		<colspec colname="col1" colwidth="150.0pt" colnum="1"/>
		<thead>
			<row>
				<entry>Test Case ID</entry>
				<entry>Author</entry>
				<entry>CR</entry>
				<entry>CRS</entry>
				<entry>Result</entry>
			</row>
		</thead>
		<tbody>


<xsl:for-each select="cluster">
	<row>
		<entry><xsl:value-of select="name"/></entry>
		<entry><xsl:value-of select="author"/></entry>
		<entry><xsl:value-of select="cr"/></entry>
		<entry><xsl:value-of select="crs"/></entry>
		<entry><xsl:value-of select="result"/></entry>
	</row>
</xsl:for-each>

		</tbody>
	</tgroup>
</table>
</section>

<section>
<title>Known Risks</title>
<para>The following test clusters fail for known reasons which do not seriously affect the quality of the release:</para>
<itemizedlist>
	<xsl:for-each select="failed_known_tests/entry">
		<listitem><para><xsl:value-of select="."/></para></listitem>
	</xsl:for-each>
</itemizedlist>
</section>

<section>
<title>Processed Tickets</title>
<xsl:choose>
	<xsl:when test="count(solved_tickets/ticket) = 0">
		<note><para>No tickets pertaining to given build <xsl:value-of select="build"/> were found.</para></note>
	</xsl:when>
	<xsl:otherwise>
		<para>The following tickets were processed for given build <xsl:value-of select="build"/>:</para>
		<table>
			<title>Processed Tickets</title>
			<tgroup cols="3">
				<colspec colname="col1" colwidth="80.0pt" colnum="1"/>
				<colspec colname="col2" colwidth="60.0pt" colnum="2"/>
				<thead>
					<row>
						<entry>Ticket Number</entry>
						<entry>Status</entry>
						<entry>Description</entry>
					</row>
				</thead>
				<tbody>
					<xsl:for-each select="solved_tickets/ticket">
						<row>
							<entry><xsl:value-of select="number"/></entry>
							<entry><xsl:value-of select="status"/></entry>
							<entry><xsl:value-of select="desc"/></entry>
						</row>
					</xsl:for-each>
				</tbody>
			</tgroup>
		</table>
		<para>Total processed test tickets: <xsl:value-of select="solved_tickets/testTickets"/></para>
		<para>Total processed development tickets: <xsl:value-of select="solved_tickets/devTickets"/></para>
		<xsl:if test="solved_tickets/mismatch">
			<caution><para>The total numbers of test and development tickets do not match, likely due to erroneous data in the database!</para></caution>
		</xsl:if>
	</xsl:otherwise>
</xsl:choose>
</section>


<!--xsl:text disable-output-escaping="yes">
long live the queen
</xsl:text-->

</chapter>
</xsl:template>
</xsl:stylesheet>
