#ifndef BOOST_ARCHIVE_BASIC_TREE_IARCHIVE_HPP
#define BOOST_ARCHIVE_BASIC_TREE_IARCHIVE_HPP

// MS compatible compilers support #pragma once
#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
// basic_tree_iarchive.hpp

// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl . 
// Use, modification and distribution is subject to the Boost Software
// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for updates, documentation, and revision history.

// archives stored as text - note these are templated on the basic
// stream templates to accommodate wide (and other?) kind of characters
//
// note the fact that on libraries without wide characters, ostream is
// is not a specialization of basic_ostream which in fact is not defined
// in such cases.   So we can't use basic_ostream<IStream::char_type> but rather
// use two template parameters

#include <boost/config.hpp>
#include <boost/serialization/pfto.hpp>
#include <boost/detail/workaround.hpp>

#include <boost/archive/detail/common_iarchive.hpp>
#include <boost/serialization/string.hpp>

#include <boost/archive/detail/abi_prefix.hpp> // must be the last header

namespace boost {
namespace archive {

/////////////////////////////////////////////////////////////////////////
// class basic_tree_iarchive - read serialized objects from an input tree stream
template<class Archive>
class basic_tree_iarchive : 
    public detail::common_iarchive<Archive>
{
protected:
#if BOOST_WORKAROUND(BOOST_MSVC, <= 1300)
public:
#elif defined(BOOST_MSVC)
    // for some inexplicable reason insertion of "class" generates compile error
    // on msvc 7.1
    friend detail::interface_iarchive<Archive>;
#else
    friend class detail::interface_iarchive<Archive>;
    friend class load_access;
#endif

    // Anything not an attribute and not a name-value pair is an
    // error and should be trapped here.
    template<class T>
    void load_override(T & t,  BOOST_PFTO int)
    {
        // If your program fails to compile here, its most likely due to
        // not specifying an nvp wrapper around the variable to
        // be serialized.
        BOOST_STATIC_ASSERT(0 == sizeof(T));
        //BOOST_MPL_ASSERT((serialization::is_wrapper<T>));
    }

    // special treatment for name-value pairs.
    typedef detail::common_iarchive<Archive> detail_common_iarchive;
    template<class T>
    void load_override(
        #ifndef BOOST_NO_FUNCTION_TEMPLATE_ORDERING
        const
        #endif
        ::boost::serialization::nvp<T> & t,
        int
    ){
        this->This()->load_start(t.name());
        this->This()->detail_common_iarchive::load_override(t.value(), 0);
        this->This()->load_end();
    }

    // specific overrides for attributes - not name value pairs so we
    // want to trap them before the above "fall through"
    void load_override(object_id_type & t, int){
        t = this->This()->Archive::m_tree_node->m_object_id;
    }

    void load_override(object_reference_type & t, int){
        t = this->This()->Archive::m_tree_node->m_object_id;
    }

    void load_override(version_type & t, int){
        t = this->This()->Archive::m_tree_node->m_version;
    }

    void load_override(tracking_type & t, int){
        t = this->This()->Archive::m_tree_node->m_tracking;
    }

    void load_override(class_id_type & t, int){
        t = this->This()->Archive::m_tree_node->m_class_id;
    }
    void load_override(class_id_optional_type & t, int){
        t = this->This()->Archive::m_tree_node->m_class_id;
    }

    void load_override(class_id_reference_type & t, int){
        t = this->This()->Archive::m_tree_node->m_class_id;
    }

    // class_name_type can't be handled here as it depends upon the
    // char type used by the stream.  So require the derived implementation
    // handle this.
    //void load_override(class_name_type & t, int){
    //    t = this->This()->Archive::m_tree_node->m_class_name;
    //}

    basic_tree_iarchive(unsigned int flags) : 
        detail::common_iarchive<Archive>(flags)
    {}
    ~basic_tree_iarchive(){}
};

} // namespace archive
} // namespace boost

#include <boost/archive/detail/abi_suffix.hpp> // pops abi_suffix.hpp pragmas

#endif // BOOST_ARCHIVE_BASIC_TREE_IARCHIVE_HPP

