#ifndef BOOST_ARCHIVE_BASIC_TREE_OARCHIVE_HPP
#define BOOST_ARCHIVE_BASIC_TREE_OARCHIVE_HPP

// MS compatible compilers support #pragma once
#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
// basic_tree_oarchive.hpp

// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com .
// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl . 
// Use, modification and distribution is subject to the Boost Software
// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for updates, documentation, and revision history.

#include <boost/config.hpp>
#include <boost/serialization/state_saver.hpp>

#include <boost/archive/detail/common_oarchive.hpp>

#include <boost/serialization/nvp.hpp>
#include <boost/serialization/tracking.hpp>
#include <boost/serialization/string.hpp>

#include <boost/mpl/assert.hpp>

#include <boost/archive/detail/abi_prefix.hpp> // must be the last header

namespace boost {
namespace archive {

//////////////////////////////////////////////////////////////////////
// class basic_tree_oarchive - write serialized objects to a tree output stream
template<class Archive>
class basic_tree_oarchive :
    public detail::common_oarchive<Archive>
{
protected:
#if BOOST_WORKAROUND(BOOST_MSVC, <= 1300)
public:
#elif defined(BOOST_MSVC)
    // for some inexplicable reason insertion of "class" generates compile erro
    // on msvc 7.1
    friend detail::interface_oarchive<Archive>;
#else
    friend class detail::interface_oarchive<Archive>;
    friend class save_access;
#endif

    // Anything not an attribute and not a name-value pair is an
    // error and should be trapped here.
    template<class T>
    void save_override(T & t, BOOST_PFTO int)
    {
        // If your program fails to compile here, its most likely due to
        // not specifying an nvp wrapper around the variable to
        // be serialized.
        BOOST_STATIC_ASSERT(0 == sizeof(T));
        //BOOST_MPL_ASSERT((serialization::is_wrapper<T>));
    }

    // special treatment for name-value pairs.
    typedef detail::common_oarchive<Archive> detail_common_oarchive;
    template<class T>
    void save_override(
        #ifndef BOOST_NO_FUNCTION_TEMPLATE_ORDERING
        const
        #endif
        ::boost::serialization::nvp<T> & t,
        int
    ){
        this->This()->save_start(t.name());
        this->This()->detail_common_oarchive::save_override(t.const_value(), 0);
        this->This()->save_end();
    }

    // specific overrides for attributes - not name value pairs so we
    // want to trap them before the above "fall through"
    void save_override(const object_id_type & t, int){
        this->This()->Archive::m_tree_node->m_object_id = t;
    }

    void save_override(const object_reference_type & t, int){
        this->This()->Archive::m_tree_node->m_object_id = t;
    }

    void save_override(const version_type & t, int){
        this->This()->Archive::m_tree_node->m_version = t;
    }

    void save_override(const tracking_type & t, int){
        this->This()->Archive::m_tree_node->m_tracking = t;
    }

    void save_override(const class_id_type & t, int){
        this->This()->Archive::m_tree_node->m_class_id = t;
    }

    void save_override(const class_id_optional_type & t, int){
        this->This()->Archive::m_tree_node->m_class_id = t;
    }

    void save_override(const class_id_reference_type & t, int){
        this->This()->Archive::m_tree_node->m_class_id = t;
    }

    // FIXME: class_name_type can't be handled here as it depends upon the
    // char type used by the stream.  So require the derived implementation
    // handle this.
    void save_override(const class_name_type & t, int){
        this->This()->Archive::m_tree_node->m_class_name = t;
    }

    basic_tree_oarchive(unsigned int flags) :
        detail_common_oarchive(flags)
    {}
    ~basic_tree_oarchive(){}
};

} // namespace archive
} // namespace boost

#include <boost/archive/detail/abi_suffix.hpp> // pops abi_suffix.hpp pragmas

#endif // BOOST_ARCHIVE_BASIC_TREE_OARCHIVE_HPP

