/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
// tree_iarchive_impl.ipp:

// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com .
// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl .
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for updates, documentation, and revision history.

#include <string>
#include <boost/config.hpp>
#include <locale>
#include <cstddef> // size_t

#if defined(BOOST_NO_STDC_NAMESPACE)
namespace std{ 
    using ::size_t; 
} // namespace std
#endif

#ifndef BOOST_NO_CWCHAR
#include <cwchar>
#ifdef BOOST_NO_STDC_NAMESPACE
namespace std{ using ::wcslen; }
#endif
#endif

//#include"boost_archive_tree_iarchive.hpp"
#include<boost/archive/archive_exception.hpp>

namespace boost { 
namespace archive {

//////////////////////////////////////////////////////////////////////
// implementation of basic_text_oprimitive overrides for the combination
// of template parameters used to create a boost_archive_tree_node

template<class Archive>
BOOST_ARCHIVE_DECL(void) 
tree_iarchive_impl<Archive>::load_override(class_name_type & t, int)
{
    const std::string & s = this->This()->Archive::m_tree_node->m_class_name;
    if(s.size() > BOOST_SERIALIZATION_MAX_KEY_SIZE - 1)
    {
	// FIXME - why this line isn't working?
	//boost::throw_exception(archive_exception::invalid_class_name);
	throw archive_exception::invalid_class_name;
    }
    char * tptr = t;
    std::memcpy(tptr, s.data(), s.size());
    tptr[s.size()] = '\0';
//   t = this->This()->Archive::m_tree_node->m_class_name;
}

#ifndef BOOST_NO_CWCHAR

/// ...

#endif // BOOST_NO_CWCHAR

template<class Archive>
BOOST_ARCHIVE_DECL(BOOST_PP_EMPTY()) 
tree_iarchive_impl<Archive>::tree_iarchive_impl(
    boost_archive_tree<char_type> & td,
    unsigned int flags
) : 
    basic_text_iprimitive<stream_type>(
        td.m_ss,
        0 != (flags & no_codecvt)
    ),
    basic_tree_iarchive<Archive>(flags),
    m_tree_node(0),
    m_tree(td),
    count(0)
{}

/*
template<class Archive>
BOOST_ARCHIVE_DECL(void)
tree_iarchive_impl<Archive>::load_binary(void *address, std::size_t count){
    #if ! defined(__MWERKS__)
    this->basic_text_iprimitive<stream_type>::load_binary
    #else
    this->basic_text_iprimitive::load_binary
    #endif
    (
        address, 
        count
    );
}
*/

} // namespace archive
} // namespace boost

