/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
// boost_archive_tree.hpp:

// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com .
// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl .
// Distributed under the Boost Software License, Version 1.0. (See
// accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

//  See http://www.boost.org for updates, documentation, and revision history.

#ifndef BOOST_ARCHIVE_TREE_HPP
#define BOOST_ARCHIVE_TREE_HPP

// MS compatible compilers support #pragma once
#if defined(_MSC_VER) && (_MSC_VER >= 1020)
# pragma once
#endif

#include <vector>
#include <sstream>
#include <boost/config.hpp>
#include <boost/archive/basic_archive.hpp>
#include <cstring> // memcpy

template<class Elem> class boost_archive_tree;

template<class Elem>
class boost_archive_tree_node {
    friend class boost_archive_tree<Elem> ;
protected:
    // pointer to parent
    const void * m_parent;
    boost_archive_tree_node(const char * name, const void * parent) :
        m_parent(parent),
        m_item_name(name),
        m_class_name(0),
        m_tracking(0),
// initialize to -1, so that gui_tree node can recognize them as unused (otherwise there would be some random number).
        m_version(-1),
        m_class_id(-1),
        m_object_id(-1)
    {}
public:
    // ownership of the item value is delegated to derived class
    // it is accessed through boost_archive_tree::get/set_value()

    // name of item from BOOST_SERIALIZATION_NVP..
    const char * m_item_name;

    // name of item from BOOST_CLASS_EXPORT..
    const char * m_class_name;

    boost::archive::tracking_type m_tracking;
    boost::archive::version_type m_version;
    // used just to lookup class name if available
    boost::archive::class_id_type m_class_id;
    boost::archive::object_id_type m_object_id;
};

template<class Elem>
class boost_archive_tree {
    // table to relate class id to class name FIXME - this is not used.
    std::vector<const char *> m_class_name_table;
    std::vector<boost_archive_tree_node<Elem>* > m_all_expanded; // FIXME - should be removed, when a better tree traversal algorithm is implemented
    void expand_all(boost_archive_tree_node<Elem>* parent);      // stupid tree traversal method
protected:
    // handle for tree control
    void * m_ctrl;
public:
    // string stream for holding text renderings of data
    std::basic_stringstream<Elem> m_ss;
    boost_archive_tree_node<Elem> * get_parent(boost_archive_tree_node<Elem> * tn);
    void set_control(void *ctrl){
        m_ctrl = ctrl;
    }
    boost_archive_tree(void * ctrl = NULL);
    boost_archive_tree_node<Elem> * next_node(
        const boost_archive_tree_node<Elem> *current,
	const unsigned int depth
    );
    boost_archive_tree_node<Elem> * make_node(
        const Elem * name,
        const boost_archive_tree_node<Elem> *parent
    );
    std::basic_string<Elem> get_value(const boost_archive_tree_node<Elem> *);
    void set_value(const boost_archive_tree_node<Elem> *, std::basic_string<Elem>);
};

#endif // BOOST_ARCHIVE_TREE_HPP


