			#ifndef BOOST_ARCHIVE_TREE_IARCHIVE_HPP
			#define BOOST_ARCHIVE_TREE_IARCHIVE_HPP
			
			// MS compatible compilers support #pragma once
			#if defined(_MSC_VER) && (_MSC_VER >= 1020)
			# pragma once
			#endif
			
			/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
			// tree_iarchive.hpp
			
			// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
			// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl . 
			// Use, modification and distribution is subject to the Boost Software
			// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
			// http://www.boost.org/LICENSE_1_0.txt)
			
			//  See http://www.boost.org for updates, documentation, and revision history.
			
			#include<istream>
			
			#include<boost/archive/detail/auto_link_archive.hpp>
			#include<boost/archive/basic_text_iprimitive.hpp>
			#include"boost_archive_basic_tree_iarchive.hpp"
			#include"boost_archive_tree.hpp"
			
			#include <boost/archive/detail/abi_prefix.hpp> // must be the last header
			
			namespace boost { 
			namespace archive {
			
			template<class Archive>
			class tree_iarchive_impl : 
			    public basic_text_iprimitive<std::istream>,
			    public basic_tree_iarchive<Archive>
			{
			#ifdef BOOST_NO_MEMBER_TEMPLATE_FRIENDS
			public:
			#else
			    friend class detail::interface_iarchive<Archive>;
			    friend class basic_tree_iarchive<Archive>;
			    friend class load_access;
			protected:
			#endif
			    // special stuff for tree input
			    typedef std::istream stream_type;
			    typedef stream_type::char_type char_type;
			    boost_archive_tree_node<char_type> * m_tree_node;
			    boost_archive_tree<char_type> & m_tree;
			    unsigned int count;
			
			    // helpers used below
			    void load_start(const char * /*name*/){ // FIXME - verify name and throw if doesn't match
			        m_tree_node = m_tree.next_node(m_tree_node,count);
			        ++count;
			    }
			
			    void load_end(){
			    }
			
			    template<class T>
			    void load(T & t){
			        m_tree.m_ss.str(m_tree.get_value(m_tree_node));
			        m_tree.m_ss.clear();
			        basic_text_iprimitive<stream_type>::load(t);
			    }
			    BOOST_ARCHIVE_DECL(void)
			    load(char * s){
			        //s = m_tree.get_value(m_tree_node).c_str();
			        std::string tstring(m_tree.get_value(m_tree_node));
			        std::memcpy(s, tstring.data(), tstring.size());
			        s[tstring.size()] = 0;
			    }
			    BOOST_ARCHIVE_DECL(void)
			    load(std::string &s){
			        s = m_tree.get_value(m_tree_node);
			    }
			    template<class T>
			    void load_override(T & t, BOOST_PFTO int){
			        basic_tree_iarchive<Archive>::load_override(t, 0);
			    }
			    BOOST_ARCHIVE_DECL(void)
			    load_override(class_name_type & t, int);
			    BOOST_ARCHIVE_DECL(BOOST_PP_EMPTY()) 
			    tree_iarchive_impl(boost_archive_tree<char_type> & td, unsigned int flags);
			    BOOST_ARCHIVE_DECL(BOOST_PP_EMPTY()) 
			    ~tree_iarchive_impl(){};
			};
			
			// do not derive from this class.  If you want to extend this functionality
			// via inhertance, derived from tree_iarchive_impl instead.  This will
			// preserve correct static polymorphism.
			class tree_iarchive : 
			    public tree_iarchive_impl<tree_iarchive>
			{
			public:
			    tree_iarchive(
			        boost_archive_tree<char_type> & td,
			        unsigned int flags = 0
			    ) :
			        tree_iarchive_impl<tree_iarchive>(td, flags)
			    {}
			    ~tree_iarchive(){}
			};
			
			} // namespace archive
			} // namespace boost
			
			// required by smart_cast for compilers not implementing 
			// partial template specialization
			BOOST_BROKEN_COMPILER_TYPE_TRAITS_SPECIALIZATION(boost::archive::tree_iarchive)
			
			#include <boost/archive/detail/abi_suffix.hpp> // pops abi_suffix.hpp pragmas
			
			#endif // BOOST_ARCHIVE_TREE_IARCHIVE_HPP


//////////// FIXME - a .cpp file?
//////////////////////////////////// #include <boost_archive_tree_iarchive.cpp>

			/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
			// tree_iarchive.cpp:
			
			// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
			// Use, modification and distribution is subject to the Boost Software
			// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
			// http://www.boost.org/LICENSE_1_0.txt)
			
			//  See http://www.boost.org for updates, documentation, and revision history.
			
			#if (defined _MSC_VER) && (_MSC_VER == 1200)
			#  pragma warning (disable : 4786) // too long name, harmless warning
			#endif
			
			#define BOOST_ARCHIVE_SOURCE
			//#include <boost/archive/tree_iarchive.hpp>
			
			//#include <boost/archive/impl/basic_tree_iarchive.ipp>
			//#include <boost/archive/impl/archive_pointer_iserializer.ipp>
			#include <boost/archive/impl/archive_serializer_map.ipp>
			#include"boost_archive_impl_tree_iarchive_impl.ipp"

			///////////////////////////////////////////////////////////////////////////////////////////
			
			namespace boost {
			namespace archive {
			
			// explicitly instantiate for this type of tree stream
			template class basic_tree_iarchive<tree_iarchive> ;
			//template class detail::archive_pointer_iserializer<tree_iarchive> ;
			template class detail::archive_serializer_map<tree_iarchive> ;
			template class tree_iarchive_impl<tree_iarchive> ;
			
			} // namespace archive
			} // namespace boost

