			#ifndef BOOST_ARCHIVE_TREE_OARCHIVE_HPP
			#define BOOST_ARCHIVE_TREE_OARCHIVE_HPP
			
			// MS compatible compilers support #pragma once
			#if defined(_MSC_VER) && (_MSC_VER >= 1020)
			# pragma once
			#endif
			
			/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
			// tree_oarchive.hpp
			
			// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
			// (C) Copyright 2006 Janek Kozicki - http://janek.kozicki.pl . 
			// Use, modification and distribution is subject to the Boost Software
			// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
			// http://www.boost.org/LICENSE_1_0.txt)
			
			//  See http://www.boost.org for updates, documentation, and revision history.
			
			#include <ostream>
			#include <cstddef> // size_t
			
			#include <boost/config.hpp>
			#if defined(BOOST_NO_STDC_NAMESPACE)
			namespace std{ 
			    using ::size_t; 
			} // namespace std
			#endif
			
			#include<boost/archive/detail/auto_link_archive.hpp>
			#include<boost/archive/basic_text_oprimitive.hpp>
			#include"boost_archive_basic_tree_oarchive.hpp"
			#include"boost_archive_tree.hpp"
			
			#include <boost/archive/detail/abi_prefix.hpp> // must be the last header
			
			namespace boost {
			namespace archive {
			
			template<class Archive>
			class tree_oarchive_impl : 
			    public basic_text_oprimitive<std::ostream>,
			    public basic_tree_oarchive<Archive>
			{
			#ifdef BOOST_NO_MEMBER_TEMPLATE_FRIENDS
			public:
			#else
			    friend class detail::interface_oarchive<Archive>;
			    friend class basic_tree_oarchive<Archive>;
			    friend class save_access;
			protected:
			#endif
			    // special stuff for tree output
			    typedef std::ostream stream_type;
			    typedef stream_type::char_type char_type;
			    boost_archive_tree_node<char_type> * m_tree_node;
			    boost_archive_tree<char_type> & m_tree;
			
			    // helpers used below
			    void save_start(const char *name){
			        // make new child node and add it into boost_archive_tree
			        m_tree_node = m_tree.make_node(name, m_tree_node);
			    }
			
			    void save_end(){
			        m_tree_node = m_tree.get_parent(m_tree_node);
			    }
			
			    template<class T>
			    void save(const T & t){
			        m_tree.m_ss.str("");
			        m_tree.m_ss.clear();
			        basic_text_oprimitive<stream_type>::save(t);
			        m_tree.set_value(m_tree_node,m_tree.m_ss.str());
			    }
			    BOOST_ARCHIVE_DECL(void) 
			    save(const char * s){
			        m_tree.set_value(m_tree_node,s);
			    };
			    BOOST_ARCHIVE_DECL(void)
			    save(const std::string &s){
			        m_tree.set_value(m_tree_node,s);
			    };
			    BOOST_ARCHIVE_DECL(BOOST_PP_EMPTY())
			    tree_oarchive_impl(boost_archive_tree<char_type> & td,unsigned int flags);
			    BOOST_ARCHIVE_DECL(BOOST_PP_EMPTY())
			    ~tree_oarchive_impl(){}
			public:
			//    void save_binary(const void *address, std::size_t count);  // FIXME - for what is it used?
			};
			
			// do not derive from this class.  If you want to extend this functionality
			// via inhertance, derived from tree_oarchive_impl instead.  This will
			// preserve correct static polymorphism.
			class tree_oarchive : 
			    public tree_oarchive_impl<tree_oarchive>
			{
			public:
			    tree_oarchive(
			        boost_archive_tree<char> & td, 
			        unsigned int flags = 0
			    ) :
			        tree_oarchive_impl<tree_oarchive>(td, flags)
			    {}
			    ~tree_oarchive(){}
			};
			
			} // namespace archive
			} // namespace boost
			
			// required by smart_cast for compilers not implementing 
			// partial template specialization
			//BOOST_SERIALIZATION_REGISTER_ARCHIVE(boost::archive::tree_oarchive)
			
			#include <boost/archive/detail/abi_suffix.hpp> // pops abi_suffix.hpp pragmas
			
			#endif // BOOST_ARCHIVE_TREE_OARCHIVE_HPP
			
//////////// FIXME - a .cpp file?
/////////////////////////////////// #include <boost/archive/tree_oarchive.cpp>


			/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
			// tree_oarchive.cpp:
			
			// (C) Copyright 2002 Robert Ramey - http://www.rrsd.com . 
			// Use, modification and distribution is subject to the Boost Software
			// License, Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
			// http://www.boost.org/LICENSE_1_0.txt)
			
			//  See http://www.boost.org for updates, documentation, and revision history.
			
			#if (defined _MSC_VER) && (_MSC_VER == 1200)
			#  pragma warning (disable : 4786) // too long name, harmless warning
			#endif
			
			#define BOOST_ARCHIVE_SOURCE
			//#include <boost/archive/tree_oarchive.hpp>
			
			//#include <boost/archive/impl/basic_tree_oarchive.ipp>
			//#include <boost/archive/impl/archive_pointer_oserializer.ipp>
			//#include <boost/archive/impl/archive_serializer_map.ipp>
			
			#include"boost_archive_impl_tree_oarchive_impl.ipp"

			////////////////////////////////////////////////////////////////////////
			
			namespace boost {
			namespace archive {
			
			// explicitly instantiate for this type of tree stream
			template class basic_tree_oarchive<tree_oarchive> ;
			template class detail::archive_serializer_map<tree_oarchive> ;
			//template class detail::archive_pointer_oserializer<tree_oarchive> ;
			template class tree_oarchive_impl<tree_oarchive> ;
			
			} // namespace archive
			} // namespace boost
			

