// this is a demo file from http://www.boost.org/doc/libs/1_43_0/libs/serialization/
// I am testing serialization on this
#include"demo_gps.hpp"

// this file adds a walkable tree type storage to boost. [1]
// [1]
// this naming boost_archive_tree.hpp is a bit non-standard, in boost upstream
// this would be boost/archive/tree.hpp, I do this on purpose to make it easier
// to distinguish between upstream and user-added content.
#include"boost_archive_tree.hpp"

// this file adds a derived class which serves as a transition from ``generic tree`` into a ``QT4 tree``
#include"qt_tree.hpp"

// add support for tree archives
// see [1] above
#include"boost_archive_tree_iarchive.hpp"
#include"boost_archive_tree_oarchive.hpp"


// add support for xml and text archives (builtin from boost)		
#include<boost/archive/text_iarchive.hpp>
#include<boost/archive/text_oarchive.hpp>
#include<boost/archive/xml_oarchive.hpp>
#include<boost/archive/xml_iarchive.hpp>

// other stuff
#include<QtGui>
#include<QMainWindow>
#include<QString>
#include<QFile>
#include<string>
#include<boost/filesystem/convenience.hpp>

class QTreeView;
class QMenu;

class MainWindow : public QMainWindow
{
	Q_OBJECT

	public:
		MainWindow();
		virtual ~MainWindow();
	public slots:
		void openFile();
		void saveFile();

	private:
		void expandAll(QTreeView* view, const QModelIndex& parent = QModelIndex());
		qt_tree<char>*	m_tree;
		QTreeView*	m_view;

		QMenu*		m_file_menu;

		bus_schedule    m_bs;
};
// qt4 MOC file, generated with: `moc-qt4 ./main.cpp > main_moc.h`
// it must be included after class MainWindow declaration
#include"main_moc.h"


MainWindow::~MainWindow()
{
	std::cerr << "END\n";
}

MainWindow::MainWindow() : QMainWindow(), m_tree(0)
{
	m_file_menu = menuBar()->addMenu(("&File"));
	m_file_menu->addAction(("&Open..."), this, SLOT(openFile()), QKeySequence(("Ctrl+O")));
	m_file_menu->addAction(("&Save..."), this, SLOT(saveFile()), QKeySequence(("Ctrl+S")));
	m_file_menu->addAction(("E&xit"), this, SLOT(close()), QKeySequence(("Ctrl+Q")));

	m_tree = new qt_tree<char>(this);
	m_view = new QTreeView(this);
	m_view->setModel(m_tree);

	setCentralWidget(m_view);
	setWindowTitle(("GUI Tree, boost::serialization test"));
};

void MainWindow::openFile()
{
	std::string file_name = QFileDialog::getOpenFileName(this, ("Open File"), ".",
			("XML boost::serialization files (*.xml);;"
			   "TXT boost::serialization files (*.txt)")).toStdString();

	if(file_name.empty())
		return;

	std::ifstream is(file_name.c_str());
	assert(is.good());
	if(boost::filesystem::extension(file_name)==".txt")
	{
		boost::archive::text_iarchive ia(is);
		ia >> boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}
	else 
	if(boost::filesystem::extension(file_name)==".xml")
	{
		boost::archive::xml_iarchive ia(is);
		ia >> boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}

	{
		boost::archive::tree_oarchive oa(*m_tree);
		oa << boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}
	m_view->setModel(m_tree);
	m_view->setUniformRowHeights(true);
	m_view->expandAll(); // qt4.2
	//expandAll(m_view);
	m_view->resizeColumnToContents(0);
	m_view->resizeColumnToContents(1);
	//m_view->expand(m_tree->index(0,0));

//	m_tree->doExpand(0,0,2,m_view);
//		void qt_tree::doExpand(int row, int column, int levels, QTreeView* tv)
//		{
//			qt_tree_node<Elem> *parentItem = ((qt_tree_node<Elem>*)tree<Elem>::m_ctrl);
//			qt_tree_node<Elem> *childItem = parentItem->child(row);
//			while( childItem && levels--)
//			{
//				tv->expand(index(row,column,createIndex(row,column,parentItem)));
//				parentItem = childItem;
//				childItem = parentItem->child(row);
//			}
//		};
	
//	std::ofstream os("demofile.xml");
//	{
//		boost::archive::xml_oarchive oa(os);
//		oa << boost::serialization::make_nvp("Bus Schedules", m_bs);
//	}
//	{
//		std::ofstream ofs("demofile.xml");
//		assert(ofs.good());
//		boost::archive::xml_oarchive oa(ofs);
////		oa << BOOST_SERIALIZATION_NVP(m_bs);
//		oa << boost::serialization::make_nvp("Bus_Schedules", m_bs);
//	}


};


void MainWindow::saveFile()
{
	std::string file_name = QFileDialog::getSaveFileName(this, ("Save File"), ".",
			("XML boost::serialization files (*.xml);;"
			   "TXT boost::serialization files (*.txt)")).toStdString();

	if(file_name.empty())
		return;

	{
		boost::archive::tree_iarchive ia(*m_tree);
		ia >> boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}
	if(boost::filesystem::extension(file_name)=="")
		file_name+=".xml";
	std::ofstream os(file_name.c_str());
	assert(os.good());
	if(boost::filesystem::extension(file_name)==".txt")
	{
		boost::archive::text_oarchive oa(os);
		oa << boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}
	else
	{
		boost::archive::xml_oarchive oa(os);
		oa << boost::serialization::make_nvp("Bus_Schedules", m_bs);
	}
};


void MainWindow::expandAll(QTreeView* view, const QModelIndex& parent)
{
	for (int i = 0; i < view->model()->rowCount(parent); ++i) 
	{
		QModelIndex index = view->model()->index(i, 0, parent);
		view->expand(index);
		const char * buf = ((boost_archive_tree_node<char>*)index.internalPointer())->m_item_name;
		std::string buf2=((qt_tree_node<char>*)index.internalPointer())->m_item_value;
		std::cout << i << " m_item_name " << (buf?buf:"") << "   " << buf2 << "\n";
		expandAll(view, index);
	}
}

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	MainWindow window;
	window.resize(640, 480);
	window.show();
	return app.exec();
}

