#ifndef QT_TREE_HPP
#define QT_TREE_HPP

#include <QList>
#include <QVariant>
#include <QAbstractItemModel>

#include <boost_archive_tree.hpp>
#include <boost/lexical_cast.hpp>

template<class Elem>
class qt_tree_node :
	public boost_archive_tree_node<Elem>
{
	friend class boost_archive_tree<Elem>;

	public:
		qt_tree_node(const Elem * name, qt_tree_node *parent = 0) :
			boost_archive_tree_node<Elem>(name,parent)
		{};

		~qt_tree_node()
		{
			qDeleteAll(m_child_items);
		};

		void appendChild(qt_tree_node *child)
		{
			m_child_items.append(child);
		};

		qt_tree_node* child(int row)
		{
			return m_child_items.value(row);
		};

		int childCount() const
		{
			return m_child_items.count();
		};

		int columnCount() const
		{
			//! change into two columns, to display only Name and Value
			return 7;
		};

		QVariant data(int column) const
		{
			if(boost_archive_tree_node<Elem>::m_parent!=0)
			switch(column)
			{
#define M(m) ((((int)m)==-1)?("-"):(boost::lexical_cast<std::string>(m).c_str()))
				default : return boost_archive_tree_node<Elem>::m_item_name;
				//case 1  : return (char*)(&(boost_archive_tree_node<Elem>::m_item_value[0]));
				case 1  : return m_item_value.c_str();
//				case 2  : return boost_archive_tree_node<Elem>::m_item_attributes.c_str();
				case 2  : return boost_archive_tree_node<Elem>::m_class_name;
				case 3  : return M(boost_archive_tree_node<Elem>::m_version  );
				case 4  : return M(boost_archive_tree_node<Elem>::m_tracking );
				case 5  : return M(boost_archive_tree_node<Elem>::m_class_id );
				case 6  : return M(boost_archive_tree_node<Elem>::m_object_id);
#undef M
			}
			else
			switch(column)
			{
				default : return "Name";
				case 1  : return "Value";
//				case 2  : return "Attributes";
				case 2  : return "Class Name";
				case 3  : return "Version";
				case 4  : return "Tracking";
				case 5  : return "Class Id";
				case 6  : return "Object Id";
			}
		};

		int row() const
		{
			if (boost_archive_tree_node<Elem>::m_parent)
				return ((qt_tree_node*)boost_archive_tree_node<Elem>::m_parent)->m_child_items.indexOf(const_cast<qt_tree_node*>(this));
			return 0;
		};

		qt_tree_node* parent()
		{
			return ((qt_tree_node<Elem>*)boost_archive_tree_node<Elem>::m_parent);
		};

	private:
		QList<qt_tree_node*> m_child_items;
	public:
		std::basic_string<Elem> m_item_value;
};

/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8
//
// boost_archive_tree members - overwritten for QT4
//
/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8

template<class Elem>
boost_archive_tree_node<Elem>* boost_archive_tree<Elem>::get_parent(boost_archive_tree_node<Elem> * tn)
{
	if (tn == 0)
		return 0;

	qt_tree_node<Elem> *childItem = static_cast<qt_tree_node<Elem>*>(tn);
	qt_tree_node<Elem> *parentItem = childItem->parent();
	if (parentItem == m_ctrl)
		return 0;

	return reinterpret_cast<boost_archive_tree_node<Elem> *>(parentItem);
}

template<class Elem>
boost_archive_tree_node<Elem>* boost_archive_tree<Elem>::make_node(const Elem * name, const boost_archive_tree_node<Elem> *parent)
{
	qt_tree_node<Elem>* h;
	if(NULL == parent)
	{
		if(m_ctrl != NULL)
			delete ((boost_archive_tree_node<Elem>*)m_ctrl);
		m_ctrl = new qt_tree_node<Elem>("root");
		h = ((qt_tree_node<Elem>*)m_ctrl);
	}
	else
	{
		h = ((qt_tree_node<Elem>*)parent);
	}

	boost_archive_tree_node<Elem> *tn = new  qt_tree_node<Elem>(name, h);
	h->appendChild(((qt_tree_node<Elem>*)tn));

	return tn;
}

template<class Elem>
boost_archive_tree_node<Elem> * boost_archive_tree<Elem>::next_node(const boost_archive_tree_node<Elem>* /*current*/, const unsigned int depth)
{
	boost_archive_tree_node<Elem>* h;
	if(depth)
	{ // get next item from expanded list
		h= ((boost_archive_tree_node<Elem>*)m_all_expanded[depth]);
	}
	else
	{ // beginning. so let's build an expanded list of all nodes.
		m_all_expanded.clear();
		h = ((boost_archive_tree_node<Elem>*)m_ctrl);
		expand_all(h);
	}

	return ((boost_archive_tree_node<Elem>*) h );
}

template<class Elem>
void boost_archive_tree<Elem>::expand_all(boost_archive_tree_node<Elem>* parent /*QTreeView* view, const QModelIndex& parent*/)
{
	int child_count = ((qt_tree_node<Elem>*)parent)->childCount();
	for (int i = 0; i < child_count ; ++i) 
	{
		qt_tree_node<Elem>* h = ((qt_tree_node<Elem>*)parent)->child(i);
		m_all_expanded.push_back(h);
		expand_all(h);
	}
}

    
template<class Elem>
boost_archive_tree<Elem>::boost_archive_tree(void * ctrl) :
	m_ctrl(ctrl)
{}
    
template<class Elem>
std::basic_string<Elem> boost_archive_tree<Elem>::get_value(const boost_archive_tree_node<Elem> * tn)
{
	return ((qt_tree_node<Elem>*)tn)->m_item_value;
};

template<class Elem>
void boost_archive_tree<Elem>::set_value(const boost_archive_tree_node<Elem> * tn, std::basic_string<Elem> v)
{
	((qt_tree_node<Elem>*)tn)->m_item_value=v;
};

/////////1/////////2/////////3/////////4/////////5/////////6/////////7/////////8

template<class Elem>
class qt_tree : 
	public QAbstractItemModel, 
	public boost_archive_tree<Elem>
{
//	Q_OBJECT

	public:
		qt_tree(QObject *parent = 0) : QAbstractItemModel(parent), boost_archive_tree<Elem>(0)
		{
			boost_archive_tree<Elem>::m_ctrl = new qt_tree_node<Elem>("init_root");
		};
		~qt_tree()
		{
			if(boost_archive_tree<Elem>::m_ctrl!=0) delete ((boost_archive_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl);
		};

		QVariant data(const QModelIndex &index, int role) const
		{
			if (!index.isValid())
				return QVariant();
			if (role != Qt::DisplayRole)
				return QVariant();
			qt_tree_node<Elem> *item = static_cast<qt_tree_node<Elem>*>(index.internalPointer());
			return item->data(index.column());
		};

		Qt::ItemFlags flags(const QModelIndex &index) const
		{
			if(!index.isValid())
				return Qt::ItemIsEnabled;
			if(index.column() == 1)
				return Qt::ItemIsEnabled | Qt::ItemIsSelectable | Qt::ItemIsEditable;
			return Qt::ItemIsEnabled | Qt::ItemIsSelectable;
		};

		bool setData ( const QModelIndex & index, const QVariant & value, int /*role*/)
		{
			boost_archive_tree<Elem>::set_value((boost_archive_tree_node<Elem>*)index.internalPointer(),value.toString().toStdString());
			//emit dataChanged();
			return true;
		};

		QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const
		{
			if (orientation == Qt::Horizontal && role == Qt::DisplayRole)
				return ((qt_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl)->data(section);
			return QVariant();
		};

		QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const
		{
			qt_tree_node<Elem> *parentItem;
			if (!parent.isValid())
				parentItem = ((qt_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl);
			else
				parentItem = static_cast<qt_tree_node<Elem>*>(parent.internalPointer());
			qt_tree_node<Elem> *childItem = parentItem->child(row);
			if (childItem)
				return createIndex(row, column, childItem);
			else
				return QModelIndex();
		};

		QModelIndex parent(const QModelIndex &index) const
		{
			if (!index.isValid())
				return QModelIndex();
			qt_tree_node<Elem> *childItem = static_cast<qt_tree_node<Elem>*>(index.internalPointer());
			qt_tree_node<Elem> *parentItem = childItem->parent();
			if (parentItem == ((qt_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl))
				return QModelIndex();
			return createIndex(parentItem->row(), 0, parentItem);
		};

		int rowCount(const QModelIndex &parent = QModelIndex()) const
		{
			qt_tree_node<Elem> *parentItem;
			if (!parent.isValid())
				parentItem = ((qt_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl);
			else
				parentItem = static_cast<qt_tree_node<Elem>*>(parent.internalPointer());
			return parentItem->childCount();
		};

		int columnCount(const QModelIndex &parent = QModelIndex()) const
		{
			if (parent.isValid())
				return static_cast<qt_tree_node<Elem>*>(parent.internalPointer())->columnCount();
			else
				return ((qt_tree_node<Elem>*)boost_archive_tree<Elem>::m_ctrl)->columnCount();
		};
};

#endif

